/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client.opers;

import java.io.IOException;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.opers.JDAPProtocolOp;

public class JDAPSearchResultReference
implements JDAPProtocolOp {
    protected String[] m_urls = null;
    protected BERElement m_element = null;

    public JDAPSearchResultReference(BERElement bERElement) throws IOException {
        this.m_element = bERElement;
        BERSequence bERSequence = (BERSequence)((BERTag)bERElement).getValue();
        if (bERSequence.size() < 0) {
            return;
        }
        this.m_urls = new String[bERSequence.size()];
        for (int i = 0; i < bERSequence.size(); ++i) {
            BEROctetString bEROctetString = (BEROctetString)bERSequence.elementAt(i);
            this.m_urls[i] = new String(bEROctetString.getValue(), "UTF8");
        }
    }

    public int getType() {
        return 19;
    }

    public BERElement getBERElement() {
        return this.m_element;
    }

    public String[] getUrls() {
        return this.m_urls;
    }

    public String toString() {
        String string = "";
        if (this.m_urls != null) {
            for (int i = 0; i < this.m_urls.length; ++i) {
                if (i != 0) {
                    string = string + ",";
                }
                string = string + this.m_urls[i];
            }
        }
        return "SearchResultReference " + string;
    }
}

