/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client.opers;

import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BERInteger;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.opers.JDAPProtocolOp;

public class JDAPBindRequest
implements JDAPProtocolOp {
    protected int m_version;
    protected String m_name = null;
    protected String m_password = null;
    protected String m_mechanism = null;
    protected byte[] m_credentials = null;

    public JDAPBindRequest(int n, String string, String string2) {
        this.m_version = n;
        this.m_name = string;
        this.m_password = string2;
    }

    public JDAPBindRequest(int n, String string, String string2, byte[] byArray) {
        this.m_version = n;
        this.m_name = string;
        this.m_mechanism = string2;
        this.m_credentials = byArray;
    }

    public int getType() {
        return 0;
    }

    public BERElement getBERElement() {
        BERElement bERElement;
        BERSequence bERSequence = new BERSequence();
        bERSequence.addElement(new BERInteger(this.m_version));
        bERSequence.addElement(new BEROctetString(this.m_name));
        BERTag bERTag = null;
        if (this.m_mechanism == null) {
            bERTag = new BERTag(128, new BEROctetString(this.m_password), true);
        } else {
            bERElement = new BERSequence();
            bERElement.addElement(new BEROctetString(this.m_mechanism));
            if (this.m_credentials == null) {
                bERElement.addElement(new BEROctetString((byte[])null));
            } else {
                bERElement.addElement(new BEROctetString(this.m_credentials, 0, this.m_credentials.length));
            }
            bERTag = new BERTag(163, bERElement, true);
        }
        bERSequence.addElement(bERTag);
        bERElement = new BERTag(96, bERSequence, true);
        return bERElement;
    }

    public String getParamString() {
        return "{version=" + this.m_version + ", name=" + this.m_name + ", authentication=" + (this.m_password == null ? this.m_password : "********") + "}";
    }

    public String toString() {
        return "BindRequest " + this.getParamString();
    }
}

