/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import netscape.ldap.LDAPSchemaElement;

public class LDAPDITStructureRuleSchema
extends LDAPSchemaElement {
    static final long serialVersionUID = -2823317246039655811L;
    public static final String FORM = "FORM";
    static final String[] NOVALS = new String[]{"OBSOLETE"};
    static final String[] IGNOREVALS;
    private String nameForm = null;
    private int ruleID = 0;

    protected LDAPDITStructureRuleSchema() {
    }

    public LDAPDITStructureRuleSchema(String string, int n, String string2, boolean bl, String string3, String[] stringArray) {
        super(string, "", string2, null);
        this.nameForm = string3;
        this.ruleID = n;
        if (bl) {
            this.setQualifier("OBSOLETE", "");
        }
        if (stringArray != null && stringArray.length > 0) {
            this.setQualifier("SUP", stringArray);
        }
    }

    public LDAPDITStructureRuleSchema(String string) {
        this.attrName = "ditStructureRules";
        this.parseValue(string);
        Object v = this.properties.get(FORM);
        if (v != null) {
            this.nameForm = (String)v;
        }
        try {
            this.ruleID = Integer.parseInt(this.oid);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String[] getSuperiors() {
        return this.getQualifier("SUP");
    }

    public int getRuleID() {
        return this.ruleID;
    }

    public String getNameForm() {
        return this.nameForm;
    }

    public String getValue() {
        String string = "( " + this.ruleID + ' ';
        if (this.name != null) {
            string = string + "NAME '" + this.name + "' ";
        }
        if (this.description != null) {
            string = string + "DESC '" + this.description + "' ";
        }
        if (this.isObsolete()) {
            string = string + "OBSOLETE ";
        }
        string = string + "FORM " + this.nameForm + ' ';
        String string2 = this.getValue("SUP", false);
        if (string2 != null && string2.length() > 1) {
            string = string + string2 + ' ';
        }
        if ((string2 = this.getCustomValues()).length() > 0) {
            string = string + string2 + ' ';
        }
        string = string + ')';
        return string;
    }

    public String toString() {
        String[] stringArray;
        String string = "Name: " + this.name + "; ruleID: " + this.ruleID + "; ";
        string = string + "Description: " + this.description;
        if (this.isObsolete()) {
            string = string + "; OBSOLETE";
        }
        if ((stringArray = this.getSuperiors()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                string = string + stringArray[i];
                if (i >= stringArray.length - 1) continue;
                string = string + ", ";
            }
        }
        string = string + "Name form: " + this.nameForm + "; ";
        string = string + this.getQualifierString(IGNOREVALS);
        return string;
    }

    static {
        for (int i = 0; i < NOVALS.length; ++i) {
            novalsTable.put(NOVALS[i], NOVALS[i]);
        }
        IGNOREVALS = new String[]{"OBSOLETE", FORM, "SUP"};
    }
}

