/*
 * Decompiled with CFR 0.152.
 */
package turbomail.authcenter.util;

import java.util.Iterator;

public class LRUCache {
    private CacheItem[] entries;
    private int capacity;
    private int size;
    private int mask;
    private CacheItem head;
    private CacheItem tail;
    private static Integer NULL = new Integer(0);

    public LRUCache(int initialCapacity) {
        int capacity = 32;
        while (capacity < 2 * initialCapacity) {
            capacity *= 2;
        }
        this.entries = new CacheItem[capacity];
        this.mask = capacity - 1;
        this.capacity = capacity / 2;
    }

    public int getCapacity() {
        return this.capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            int i = 0;
            while (i < this.entries.length) {
                CacheItem item = this.entries[i];
                this.entries[i] = null;
                ++i;
            }
        }
        this.size = 0;
        this.head = null;
        this.tail = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get(Object key) {
        if (key == null) {
            key = NULL;
        }
        int hash = key.hashCode() & this.mask;
        int count = this.size + 1;
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            while (true) {
                if (count <= 0) {
                    return null;
                }
                CacheItem item = this.entries[hash];
                if (item == null) {
                    return null;
                }
                if (item.key == key || item.key.equals(key)) {
                    this.updateLru(item);
                    return item.value;
                }
                hash = hash + 1 & this.mask;
                --count;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object put(Object key, Object value) {
        if (key == null) {
            key = NULL;
        }
        while (this.size >= this.capacity) {
            this.remove(this.tail.key);
        }
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            int hash = key.hashCode() & this.mask;
            int count = this.size + 1;
            while (true) {
                if (count <= 0) {
                    throw new RuntimeException();
                }
                CacheItem item = this.entries[hash];
                if (item == null) {
                    this.entries[hash] = item = new CacheItem(key, value);
                    ++this.size;
                    item.next = this.head;
                    if (this.head != null) {
                        this.head.prev = item;
                    }
                    this.head = item;
                    if (this.tail != null) return null;
                    this.tail = item;
                    return null;
                }
                if (item.key == key || item.key.equals(key)) {
                    this.updateLru(item);
                    Object oldValue = item.value;
                    item.value = value;
                    return oldValue;
                }
                hash = hash + 1 & this.mask;
                --count;
            }
        }
    }

    private void updateLru(CacheItem item) {
        CacheItem prev = item.prev;
        CacheItem next = item.next;
        if (prev != null) {
            prev.next = next;
            item.prev = null;
            item.next = this.head;
            this.head.prev = item;
            this.head = item;
            if (next != null) {
                next.prev = prev;
            } else {
                this.tail = prev;
            }
        }
    }

    public boolean removeTail() {
        CacheItem last = this.tail;
        if (last == null) {
            return false;
        }
        this.remove(last.key);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public Object remove(Object key) {
        if (key == null) {
            key = NULL;
        }
        int hash = key.hashCode() & this.mask;
        int count = this.size + 1;
        Object value = null;
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            while (count > 0) {
                CacheItem item = this.entries[hash];
                if (item == null) {
                    return null;
                }
                if (item.key == key || item.key.equals(key)) {
                    this.entries[hash] = null;
                    --this.size;
                    CacheItem prev = item.prev;
                    CacheItem next = item.next;
                    if (prev != null) {
                        prev.next = next;
                    } else {
                        this.head = next;
                    }
                    if (next != null) {
                        next.prev = prev;
                    } else {
                        this.tail = prev;
                    }
                    int i = 1;
                    while (i <= count) {
                        int nextHash = hash + i & this.mask;
                        CacheItem nextItem = this.entries[nextHash];
                        if (nextItem == null) break;
                        this.entries[nextHash] = null;
                        this.refillEntry(nextItem);
                        ++i;
                    }
                    value = item.value;
                    break;
                }
                hash = hash + 1 & this.mask;
                --count;
            }
        }
        if (count < 0) {
            throw new RuntimeException("internal cache error");
        }
        return value;
    }

    private void refillEntry(CacheItem item) {
        int baseHash = item.key.hashCode();
        int count = 0;
        while (count < this.size + 1) {
            int hash = baseHash + count & this.mask;
            if (this.entries[hash] == null) {
                this.entries[hash] = item;
                return;
            }
            ++count;
        }
    }

    public Iterator keys() {
        KeyIterator iter = new KeyIterator();
        iter.init(this);
        return iter;
    }

    public Iterator keys(Iterator oldIter) {
        KeyIterator iter = (KeyIterator)oldIter;
        iter.init(this);
        return iter;
    }

    public Iterator values() {
        ValueIterator iter = new ValueIterator();
        iter.init(this);
        return iter;
    }

    public Iterator values(Iterator oldIter) {
        ValueIterator iter = (ValueIterator)oldIter;
        iter.init(this);
        return iter;
    }

    static class CacheItem {
        CacheItem prev;
        CacheItem next;
        Object key;
        Object value;
        int index;

        CacheItem(Object key, Object value) {
            this.key = key;
            this.value = value;
        }
    }

    static class KeyIterator
    implements Iterator {
        CacheItem item;

        KeyIterator() {
        }

        void init(LRUCache cache) {
            this.item = cache.head;
        }

        public boolean hasNext() {
            return this.item != null;
        }

        public Object next() {
            Object value = this.item.key;
            this.item = this.item.next;
            return value;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class ValueIterator
    implements Iterator {
        CacheItem item;

        ValueIterator() {
        }

        void init(LRUCache cache) {
            this.item = cache.head;
        }

        public boolean hasNext() {
            return this.item != null;
        }

        public Object next() {
            Object value = this.item.value;
            this.item = this.item.next;
            return value;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

