/*
 * Decompiled with CFR 0.152.
 */
package turbomail.authcenter.util;

import java.io.InputStream;
import turbomail.authcenter.util.FreeList;

public final class CharBuffer {
    private static FreeList freeList = new FreeList(128);
    private char[] buffer;
    private int capacity;
    private int length;

    public CharBuffer() {
        this.capacity = 16;
        this.buffer = new char[this.capacity];
        this.length = 0;
    }

    public CharBuffer(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        if (capacity < 16) {
            capacity = 16;
        }
        this.capacity = capacity;
        this.buffer = new char[capacity];
        this.length = 0;
    }

    public CharBuffer(String string) {
        this.capacity = string.length();
        if (this.capacity < 16) {
            this.capacity = 16;
        }
        this.buffer = new char[this.capacity];
        this.length = string.length();
        string.getChars(0, this.length, this.buffer, 0);
    }

    public CharBuffer(String string, int offset, int length) {
        this.capacity = length;
        if (this.capacity < 16) {
            this.capacity = 16;
        }
        this.buffer = new char[this.capacity];
        string.getChars(offset, length, this.buffer, 0);
    }

    public static CharBuffer allocate() {
        CharBuffer cb = (CharBuffer)freeList.allocate();
        if (cb != null) {
            cb.length = 0;
            return cb;
        }
        return new CharBuffer();
    }

    public void free() {
        if (this.capacity <= 256) {
            freeList.free(this);
        }
    }

    public int length() {
        return this.length;
    }

    public int getLength() {
        return this.length;
    }

    public int capacity() {
        return this.capacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    /*
     * Unable to fully structure code
     */
    public void ensureCapacity(int minimumCapacity) {
        block2: {
            if (minimumCapacity <= this.capacity) {
                return;
            }
            oldCapacity = this.capacity;
            if (minimumCapacity <= 4096) ** GOTO lbl8
            this.capacity = 4096 * ((minimumCapacity + 4095) / 4096);
            break block2;
lbl-1000:
            // 1 sources

            {
                this.capacity *= 2;
lbl8:
                // 2 sources

                ** while (this.capacity < minimumCapacity)
            }
        }
        chars = new char[this.capacity];
        System.arraycopy(this.buffer, 0, chars, 0, oldCapacity);
        this.buffer = chars;
    }

    public final void clear() {
        this.length = 0;
    }

    public final void setLength(int newLength) {
        if (newLength < 0) {
            throw new IndexOutOfBoundsException("illegal argument");
        }
        if (newLength > this.capacity) {
            this.ensureCapacity(newLength);
        }
        this.length = newLength;
    }

    public char charAt(int i) {
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[i];
    }

    public char getLastChar() {
        if (this.length == 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[this.length - 1];
    }

    public final char[] getBuffer() {
        return this.buffer;
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        while (srcBegin < srcEnd) {
            dst[dstBegin++] = this.buffer[srcBegin];
        }
    }

    public void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer[index] = ch;
    }

    public CharBuffer append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public CharBuffer append(CharBuffer cb) {
        return this.append(cb.buffer, 0, cb.length);
    }

    public CharBuffer append(String string) {
        int len;
        if (string == null) {
            string = "null";
        }
        if ((len = string.length()) + this.length >= this.capacity) {
            this.ensureCapacity(len + this.length);
        }
        string.getChars(0, len, this.buffer, this.length);
        this.length += len;
        return this;
    }

    public CharBuffer append(String string, int offset, int len) {
        if (len + this.length >= this.capacity) {
            this.ensureCapacity(len + this.length);
        }
        string.getChars(offset, offset + len, this.buffer, this.length);
        this.length += len;
        return this;
    }

    public CharBuffer append(char[] buffer) {
        return this.append(buffer, 0, buffer.length);
    }

    public CharBuffer append(char[] buffer, int offset, int length) {
        if (this.length + length > this.capacity) {
            this.ensureCapacity(this.length + length);
        }
        System.arraycopy(buffer, offset, this.buffer, this.length, length);
        this.length += length;
        return this;
    }

    public final CharBuffer append(boolean b) {
        return this.append(String.valueOf(b));
    }

    public final CharBuffer append(char ch) {
        if (this.length >= this.capacity) {
            this.ensureCapacity(this.length + 1);
        }
        this.buffer[this.length++] = ch;
        return this;
    }

    public CharBuffer append(int i) {
        if (this.length + 16 >= this.capacity) {
            this.ensureCapacity(this.length + 16);
        }
        if (i < 0) {
            this.buffer[this.length++] = 45;
            i = -i;
        } else if (i == 0) {
            this.buffer[this.length++] = 48;
            return this;
        }
        int start = this.length;
        while (i > 0) {
            this.buffer[this.length++] = (char)(i % 10 + 48);
            i /= 10;
        }
        int j = (this.length - start) / 2;
        while (j > 0) {
            char temp = this.buffer[this.length - j];
            this.buffer[this.length - j] = this.buffer[start + j - 1];
            this.buffer[start + j - 1] = temp;
            --j;
        }
        return this;
    }

    public CharBuffer append(long i) {
        if (this.length + 32 >= this.capacity) {
            this.ensureCapacity(this.length + 32);
        }
        if (i < 0L) {
            this.buffer[this.length++] = 45;
            i = -i;
        } else if (i == 0L) {
            this.buffer[this.length++] = 48;
            return this;
        }
        int start = this.length;
        while (i > 0L) {
            this.buffer[this.length++] = (char)(i % 10L + 48L);
            i /= 10L;
        }
        int j = (this.length - start) / 2;
        while (j > 0) {
            char temp = this.buffer[this.length - j];
            this.buffer[this.length - j] = this.buffer[start + j - 1];
            this.buffer[start + j - 1] = temp;
            --j;
        }
        return this;
    }

    public CharBuffer append(float f) {
        return this.append(String.valueOf(f));
    }

    public CharBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public final CharBuffer append(byte[] buf, int offset, int len) {
        if (this.length + len >= this.capacity) {
            this.ensureCapacity(this.length + len);
        }
        while (len > 0) {
            this.buffer[this.length++] = (char)buf[offset++];
            --len;
        }
        return this;
    }

    public CharBuffer delete(int start, int end) {
        if (start < 0 || start > end || start > this.length) {
            throw new StringIndexOutOfBoundsException();
        }
        if (end > this.length) {
            end = this.length;
        }
        int tail = this.length - end;
        int i = 0;
        while (i < tail) {
            this.buffer[start + i] = this.buffer[end + i];
            ++i;
        }
        this.length -= end - start;
        return this;
    }

    public CharBuffer deleteCharAt(int index) {
        if (index < 0 || index > this.length) {
            throw new StringIndexOutOfBoundsException();
        }
        if (index == this.length) {
            return this;
        }
        int tail = this.length - index + 1;
        int i = 0;
        while (i < tail) {
            this.buffer[index + i] = this.buffer[index + i + 1];
            ++i;
        }
        --this.length;
        return this;
    }

    public CharBuffer replace(int start, int end, String string) {
        if (start < 0 || start > end || start > this.length) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = string.length();
        if (len + this.length - (end - start) > this.capacity) {
            this.ensureCapacity(len + this.length - (end - start));
        }
        if (len < end - start) {
            int tail = this.length - end;
            int i = 0;
            while (i < tail) {
                this.buffer[start + len + i] = this.buffer[end + i];
                ++i;
            }
        } else {
            int tail = this.length - end;
            int i = tail - 1;
            while (i >= 0) {
                this.buffer[end + i] = this.buffer[start + len + i];
                --i;
            }
        }
        string.getChars(0, len, this.buffer, start);
        return this;
    }

    public CharBuffer replace(int start, int end, char[] buffer, int offset, int len) {
        if (start < 0 || start > end || start > this.length) {
            throw new StringIndexOutOfBoundsException();
        }
        if (len + this.length - (end - start) > this.capacity) {
            this.ensureCapacity(len + this.length - (end - start));
        }
        if (len < end - start) {
            int tail = this.length - end;
            int i = 0;
            while (i < tail) {
                this.buffer[start + len + i] = this.buffer[end + i];
                ++i;
            }
        } else {
            int tail = this.length - end;
            int i = tail - 1;
            while (i >= 0) {
                this.buffer[end + i] = this.buffer[start + len + i];
                --i;
            }
        }
        System.arraycopy(buffer, offset, this.buffer, start, len);
        return this;
    }

    public String substring(int start) {
        if (start > this.length || start < 0) {
            throw new StringIndexOutOfBoundsException();
        }
        return new String(this.buffer, start, this.length - start);
    }

    public String substring(int start, int end) {
        if (start > this.length || start < 0 || start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        return new String(this.buffer, start, end - start);
    }

    public CharBuffer insert(int index, String string) {
        if (string == null) {
            string = "null";
        }
        if (index < 0 || index > this.length) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = string.length();
        if (this.length + len > this.capacity) {
            this.ensureCapacity(len + this.length);
        }
        int tail = this.length - index;
        int i = tail - 1;
        while (i >= 0) {
            this.buffer[index + len + i] = this.buffer[index + i];
            --i;
        }
        string.getChars(0, len, this.buffer, index);
        this.length += len;
        return this;
    }

    public CharBuffer insert(int index, char[] buffer, int offset, int len) {
        if (index < 0 || index > this.length) {
            throw new StringIndexOutOfBoundsException();
        }
        if (len + this.length > this.capacity) {
            this.ensureCapacity(len + this.length);
        }
        int tail = this.length - index;
        int i = tail - 1;
        while (i >= 0) {
            this.buffer[index + len + i] = this.buffer[index + i];
            --i;
        }
        System.arraycopy(buffer, offset, this.buffer, index, len);
        this.length += len;
        return this;
    }

    public CharBuffer insert(int offset, Object o) {
        return this.insert(offset, String.valueOf(o));
    }

    public CharBuffer insert(int offset, char ch) {
        return this.insert(offset, String.valueOf(ch));
    }

    public CharBuffer insert(int offset, int i) {
        return this.insert(offset, String.valueOf(i));
    }

    public CharBuffer insert(int offset, long l) {
        return this.insert(offset, String.valueOf(l));
    }

    public CharBuffer insert(int offset, float f) {
        return this.insert(offset, String.valueOf(f));
    }

    public CharBuffer insert(int offset, double d) {
        return this.insert(offset, String.valueOf(d));
    }

    public int indexOf(char ch, int start) {
        if (start < 0) {
            start = 0;
        }
        while (start < this.length) {
            if (this.buffer[start] == ch) {
                return start;
            }
            ++start;
        }
        return -1;
    }

    public int indexOf(char ch) {
        return this.indexOf(ch, 0);
    }

    public int lastIndexOf(char ch, int start) {
        if (start >= this.length) {
            start = this.length - 1;
        }
        while (start >= 0) {
            if (this.buffer[start] == ch) {
                return start;
            }
            --start;
        }
        return -1;
    }

    public int lastIndexOf(char ch) {
        return this.lastIndexOf(ch, this.length - 1);
    }

    public Object clone() {
        CharBuffer newBuffer = new CharBuffer();
        newBuffer.setLength(this.length);
        System.arraycopy(this.buffer, 0, newBuffer.buffer, 0, this.length);
        return newBuffer;
    }

    public int hashCode() {
        int hash = 0;
        int i = 0;
        while (i < this.length) {
            hash = 65521 * hash + this.buffer[i] * 251 + 1021;
            ++i;
        }
        return hash;
    }

    public final boolean equals(Object a) {
        if (this == a) {
            return true;
        }
        if (a instanceof CharBuffer) {
            CharBuffer cb = (CharBuffer)a;
            if (this.length != cb.length) {
                return false;
            }
            int i = 0;
            while (i < this.length) {
                if (this.buffer[i] != cb.buffer[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public final boolean equals(CharBuffer cb) {
        if (this.length != cb.length) {
            return false;
        }
        int i = 0;
        while (i < this.length) {
            if (this.buffer[i] != cb.buffer[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final boolean equalsIgnoreCase(String a) {
        int len = a.length();
        if (this.length != len) {
            return false;
        }
        int i = 0;
        while (i < len) {
            char ca = this.buffer[i];
            char cb = a.charAt(i);
            if (ca != cb && Character.toLowerCase(ca) != Character.toLowerCase(cb)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final boolean equalsIgnoreCase(CharBuffer b) {
        if (this.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < this.length) {
            char ca = this.buffer[i];
            char cb = b.buffer[i];
            if (ca != cb && Character.toLowerCase(ca) != Character.toLowerCase(cb)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean matches(Object a) {
        if (a instanceof CharBuffer) {
            CharBuffer cb = (CharBuffer)a;
            if (this.length != cb.length) {
                return false;
            }
            int i = 0;
            while (i < this.length) {
                if (this.buffer[i] != cb.buffer[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (a instanceof String) {
            String sa = (String)a;
            if (this.length != sa.length()) {
                return false;
            }
            int i = 0;
            while (i < this.length) {
                if (this.buffer[i] != sa.charAt(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean matches(String sa) {
        if (this.length != sa.length()) {
            return false;
        }
        int i = 0;
        while (i < this.length) {
            if (this.buffer[i] != sa.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean matchesIgnoreCase(String sa) {
        if (this.length != sa.length()) {
            return false;
        }
        int i = 0;
        while (i < this.length) {
            char ca = this.buffer[i];
            char cb = sa.charAt(i);
            if (ca != cb && Character.toLowerCase(ca) != Character.toLowerCase(cb)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean regionMatches(int off1, CharBuffer buf, int off2, int len) {
        if (off1 + len > this.length || off2 + len > buf.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (this.buffer[off1 + i] != buf.buffer[off2 + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean regionMatches(int off1, String buf, int off2, int len) {
        return this.regionMatches(off1, new CharBuffer(buf), off2, len);
    }

    public CharBuffer toLowerCase() {
        char[] buffer = this.buffer;
        int length = this.length;
        int i = 0;
        while (i < length) {
            buffer[i] = Character.toLowerCase(buffer[i]);
            ++i;
        }
        return this;
    }

    public boolean regionMatchesIgnoreCase(int off1, CharBuffer buf, int off2, int len) {
        if (off1 + len > this.length || off2 + len > buf.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (Character.toLowerCase(this.buffer[off1 + i]) != Character.toLowerCase(buf.buffer[off2 + i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean startsWith(String string) {
        if (string == null) {
            return false;
        }
        int strlen = string.length();
        if (this.length < strlen) {
            return false;
        }
        return this.regionMatches(0, string, 0, strlen);
    }

    public boolean endsWith(String string) {
        if (string == null) {
            return false;
        }
        int strlen = string.length();
        if (this.length < strlen) {
            return false;
        }
        return this.regionMatches(this.length - strlen, string, 0, strlen);
    }

    public String toString() {
        return new String(this.buffer, 0, this.length);
    }

    public String close() {
        String string = new String(this.buffer, 0, this.length);
        this.free();
        return string;
    }

    public InputStream getInputStream() {
        return new CBInputStream();
    }

    class CBInputStream
    extends InputStream {
        int index = 0;

        CBInputStream() {
        }

        public int read() {
            if (this.index >= CharBuffer.this.length) {
                return -1;
            }
            return CharBuffer.this.buffer[this.index++];
        }
    }
}

