/*
 * Decompiled with CFR 0.152.
 */
package turbomail.authcenter.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ByteBuffer {
    byte[] buffer;
    int capacity;
    int length;

    /*
     * Unable to fully structure code
     */
    public ByteBuffer(int minimumCapacity) {
        block1: {
            super();
            this.capacity = 32;
            if (minimumCapacity <= 4096) ** GOTO lbl7
            this.capacity = minimumCapacity + 4095 & -4096;
            break block1;
lbl-1000:
            // 1 sources

            {
                this.capacity += this.capacity;
lbl7:
                // 2 sources

                ** while (this.capacity < minimumCapacity)
            }
        }
        this.buffer = new byte[minimumCapacity];
        this.length = 0;
    }

    public ByteBuffer() {
        this.buffer = new byte[32];
        this.capacity = this.buffer.length;
        this.length = 0;
    }

    public int capacity() {
        return this.capacity;
    }

    public int hashCode() {
        int hash = 17;
        int i = this.length - 1;
        while (i >= 0) {
            hash = 65537 * hash + this.buffer[i];
            --i;
        }
        return hash;
    }

    /*
     * Unable to fully structure code
     */
    public void ensureCapacity(int minimumCapacity) {
        block2: {
            if (minimumCapacity <= this.capacity) {
                return;
            }
            if (minimumCapacity <= 4096) ** GOTO lbl7
            this.capacity = minimumCapacity + 4095 & -4096;
            break block2;
lbl-1000:
            // 1 sources

            {
                this.capacity += this.capacity;
lbl7:
                // 2 sources

                ** while (this.capacity < minimumCapacity)
            }
        }
        bytes = new byte[this.capacity];
        System.arraycopy(this.buffer, 0, bytes, 0, this.length);
        this.buffer = bytes;
    }

    public int length() {
        return this.length;
    }

    public int size() {
        return this.length;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int len) {
        if (len < 0) {
            throw new RuntimeException("illegal argument");
        }
        if (len > this.capacity) {
            this.ensureCapacity(len);
        }
        this.length = len;
    }

    public void clear() {
        this.length = 0;
    }

    public byte[] getBuffer() {
        byte[] buf = null;
        if (this.length == 0) {
            buf = new byte[]{};
            return buf;
        }
        buf = new byte[this.length];
        System.arraycopy(this.buffer, 0, buf, 0, this.length);
        return buf;
    }

    public void append(int b) {
        if (this.length + 1 > this.capacity) {
            this.ensureCapacity(this.length + 1);
        }
        this.buffer[this.length++] = (byte)b;
    }

    public void append(long b) {
        if (this.length + 1 > this.capacity) {
            this.ensureCapacity(this.length + 1);
        }
        this.buffer[this.length++] = (byte)b;
    }

    public void add(int i, byte[] buffer, int offset, int length) {
        if (this.length + length > this.capacity) {
            this.ensureCapacity(this.length + length);
        }
        System.arraycopy(this.buffer, i, this.buffer, i + length, this.length - i);
        System.arraycopy(buffer, offset, this.buffer, i, length);
        this.length += length;
    }

    public void add(byte[] buffer, int offset, int length) {
        if (this.length + length > this.capacity) {
            this.ensureCapacity(this.length + length);
        }
        System.arraycopy(buffer, offset, this.buffer, this.length, length);
        this.length += length;
    }

    public void add(int i, int data) {
        if (this.length + 1 > this.capacity) {
            this.ensureCapacity(this.length + 1);
        }
        System.arraycopy(this.buffer, i, this.buffer, i + 1, this.length - i);
        this.buffer[i] = (byte)data;
        ++this.length;
    }

    public void add(int data) {
        if (this.length + 1 > this.capacity) {
            this.ensureCapacity(this.length + 1);
        }
        this.buffer[this.length++] = (byte)data;
    }

    public void set(int i, byte[] buffer, int offset, int length) {
        System.arraycopy(buffer, offset, this.buffer, i, length);
    }

    public void set(int i, int data) {
        this.buffer[i] = (byte)data;
    }

    public void insert(int i, byte[] buffer, int offset, int length) {
        if (this.length + length > this.capacity) {
            this.ensureCapacity(this.length + length);
        }
        System.arraycopy(this.buffer, i, this.buffer, i + length, this.length - i);
        System.arraycopy(buffer, offset, this.buffer, i, length);
        this.length += length;
    }

    public void replace(int i, byte[] buffer, int offset, int length) {
        System.arraycopy(buffer, offset, this.buffer, i, length);
    }

    public void append(byte[] buffer) {
        if (this.length + buffer.length >= this.capacity) {
            this.ensureCapacity(this.length + buffer.length);
        }
        System.arraycopy(buffer, 0, this.buffer, this.length, buffer.length);
        this.length += buffer.length;
    }

    public void append(byte[] buffer, int offset, int length) {
        if (this.length + length >= this.capacity) {
            this.ensureCapacity(this.length + length);
        }
        System.arraycopy(buffer, offset, this.buffer, this.length, length);
        this.length += length;
    }

    public void replaceShort(int i, int s) {
        this.buffer[i] = (byte)(s >> 8);
        this.buffer[i + 1] = (byte)s;
    }

    public void appendShort(int s) {
        if (this.length + 2 > this.capacity) {
            this.ensureCapacity(this.length + 2);
        }
        this.replaceShort(this.length, s);
        this.length += 2;
    }

    public void addShort(int s) {
        if (this.length + 2 > this.capacity) {
            this.ensureCapacity(this.length + 2);
        }
        this.buffer[this.length++] = (byte)(s >> 8);
        this.buffer[this.length++] = (byte)s;
    }

    public void addShort(int i, int s) {
        this.add(i, (byte)(s >> 8));
        this.add(i + 1, (byte)s);
    }

    public void setShort(int i, int s) {
        this.buffer[i] = (byte)(s >> 8);
        this.buffer[i + 1] = (byte)s;
    }

    public void replaceInt(int i, int v) {
        this.buffer[i] = (byte)(v >> 24);
        this.buffer[i + 1] = (byte)(v >> 16);
        this.buffer[i + 2] = (byte)(v >> 8);
        this.buffer[i + 3] = (byte)v;
    }

    public void appendInt(int v) {
        if (this.length + 4 > this.capacity) {
            this.ensureCapacity(this.length + 4);
        }
        this.replaceInt(this.length, v);
        this.length += 4;
    }

    public void addInt(int s) {
        if (this.length + 4 > this.capacity) {
            this.ensureCapacity(this.length + 4);
        }
        this.buffer[this.length++] = (byte)(s >> 24);
        this.buffer[this.length++] = (byte)(s >> 16);
        this.buffer[this.length++] = (byte)(s >> 8);
        this.buffer[this.length++] = (byte)s;
    }

    public void addInt(int i, int s) {
        this.add(i + 0, (byte)(s >> 24));
        this.add(i + 1, (byte)(s >> 16));
        this.add(i + 2, (byte)(s >> 8));
        this.add(i + 3, (byte)s);
    }

    public void setInt(int i, int v) {
        this.buffer[i] = (byte)(v >> 24);
        this.buffer[i + 1] = (byte)(v >> 16);
        this.buffer[i + 2] = (byte)(v >> 8);
        this.buffer[i + 3] = (byte)v;
    }

    public void addDouble(double v) {
        if (this.length + 8 > this.capacity) {
            this.ensureCapacity(this.length + 8);
        }
        long bits = Double.doubleToLongBits(v);
        this.buffer[this.length++] = (byte)(bits >> 56);
        this.buffer[this.length++] = (byte)(bits >> 48);
        this.buffer[this.length++] = (byte)(bits >> 40);
        this.buffer[this.length++] = (byte)(bits >> 32);
        this.buffer[this.length++] = (byte)(bits >> 24);
        this.buffer[this.length++] = (byte)(bits >> 16);
        this.buffer[this.length++] = (byte)(bits >> 8);
        this.buffer[this.length++] = (byte)bits;
    }

    public void addString(String s) {
        int len = s.length();
        if (len + this.length > this.capacity) {
            this.ensureCapacity(this.length + len);
        }
        int i = 0;
        while (i < len) {
            this.buffer[this.length++] = (byte)s.charAt(i);
            ++i;
        }
    }

    public void add(char[] s, int offset, int len) {
        if (len + this.length > this.capacity) {
            this.ensureCapacity(this.length + len);
        }
        int i = 0;
        while (i < len) {
            this.buffer[this.length++] = (byte)s[offset + i];
            ++i;
        }
    }

    public void remove(int begin, int length) {
        System.arraycopy(this.buffer, begin + length, this.buffer, begin, this.capacity - length - begin);
        this.length -= length;
    }

    public void append(String string) {
        int i = 0;
        while (i < string.length()) {
            this.append(string.charAt(i));
            ++i;
        }
    }

    public byte byteAt(int i) {
        if (i < 0 || i > this.length) {
            throw new RuntimeException();
        }
        return this.buffer[i];
    }

    public void setByteAt(int i, int b) {
        this.buffer[i] = (byte)b;
    }

    public byte get(int i) {
        if (i < 0 || i >= this.length) {
            throw new RuntimeException("out of bounds: " + i + " len: " + this.length);
        }
        return this.buffer[i];
    }

    public short getShort(int i) {
        if (i < 0 || i + 1 >= this.length) {
            throw new RuntimeException("out of bounds: " + i + " len: " + this.length);
        }
        return (short)(((this.buffer[i] & 0xFF) << 8) + (this.buffer[i + 1] & 0xFF));
    }

    public int getInt(int i) {
        if (i < 0 || i + 3 >= this.length) {
            throw new RuntimeException("out of bounds: " + i + " len: " + this.length);
        }
        return ((this.buffer[i + 0] & 0xFF) << 24) + ((this.buffer[i + 1] & 0xFF) << 16) + ((this.buffer[i + 2] & 0xFF) << 8) + (this.buffer[i + 3] & 0xFF);
    }

    public Object clone() {
        ByteBuffer newBuffer = new ByteBuffer(this.length);
        System.arraycopy(this.buffer, 0, newBuffer.buffer, 0, this.length);
        return newBuffer;
    }

    public boolean equals(Object b) {
        if (!(b instanceof ByteBuffer)) {
            return false;
        }
        ByteBuffer bb = (ByteBuffer)b;
        if (bb.length != this.length) {
            return false;
        }
        int i = this.length - 1;
        while (i >= 0) {
            if (bb.buffer[i] != this.buffer[i]) {
                return false;
            }
            --i;
        }
        return true;
    }

    public String toString() {
        return new String(this.buffer, 0, this.length);
    }

    public String toString(String encoding) {
        try {
            return new String(this.buffer, 0, this.length, encoding);
        }
        catch (Exception e) {
            return new String(this.buffer, 0, this.length);
        }
    }

    static class BBInputStream
    extends InputStream {
        ByteBuffer buf;
        int index;

        public int available() {
            return this.buf.length - this.index;
        }

        public int read() throws IOException {
            if (this.index >= this.buf.length) {
                return -1;
            }
            return this.buf.buffer[this.index++] & 0xFF;
        }

        BBInputStream(ByteBuffer buf) {
            this.buf = buf;
        }
    }

    static class BBOutputStream
    extends OutputStream {
        ByteBuffer buf;

        public void write(int ch) throws IOException {
            this.buf.append(ch);
        }

        BBOutputStream(ByteBuffer buf) {
            this.buf = buf;
        }
    }
}

