/*
 * Decompiled with CFR 0.152.
 */
package turbomail.authcenter.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import turbomail.authcenter.util.StringConverter;

class ByteArray {
    private byte[] data;

    ByteArray(String s) {
        this.data = StringConverter.hexToByte(s);
    }

    ByteArray(byte[] a) {
        this.data = a;
    }

    byte[] byteValue() {
        return this.data;
    }

    int compareTo(ByteArray o) {
        int len = this.data.length;
        int lenb = o.data.length;
        int i = 0;
        while (true) {
            int a = 0;
            int b = 0;
            if (i < len) {
                a = this.data[i] & 0xFF;
            } else if (i >= lenb) {
                return 0;
            }
            if (i < lenb) {
                b = o.data[i] & 0xFF;
            }
            if (a > b) {
                return 1;
            }
            if (b > a) {
                return -1;
            }
            ++i;
        }
    }

    static byte[] serialize(Object s) throws Exception {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(bo);
        os.writeObject(s);
        return bo.toByteArray();
    }

    static String serializeToString(Object s) throws Exception {
        return ByteArray.createString(ByteArray.serialize(s));
    }

    Object deserialize() throws Exception {
        ByteArrayInputStream bi = new ByteArrayInputStream(this.data);
        ObjectInputStream is = new ObjectInputStream(bi);
        return is.readObject();
    }

    static String createString(byte[] b) {
        return StringConverter.byteToHex(b);
    }

    public String toString() {
        return ByteArray.createString(this.data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }
}

