/*
 * Decompiled with CFR 0.152.
 */
package turbomail.authcenter.http.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import turbomail.authcenter.http.ResponseHeader;
import turbomail.authcenter.util.ByteBuffer;

public class WOutputStream
extends OutputStream {
    private OutputStream out = null;
    private boolean isopen;
    private boolean isfirst;
    private ResponseHeader rh = null;
    private ByteBuffer bb = new ByteBuffer();
    private int buf_size = 1024;
    private boolean b_Direct = false;
    public boolean shouldSendContentLength = true;

    public WOutputStream(OutputStream out, ResponseHeader rh) {
        this.out = out;
        this.rh = rh;
        this.isopen = true;
        this.isfirst = true;
        this.bb.ensureCapacity(this.buf_size);
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void SetDirect(boolean bD) {
        this.b_Direct = bD;
    }

    public boolean isOpen() {
        return this.isopen;
    }

    public void setBufferSize(int size) {
        this.buf_size = size;
        this.bb.ensureCapacity(size);
    }

    public int getBufferSize() {
        return this.buf_size;
    }

    public void write(int b) throws IOException {
        if (!this.isopen) {
            throw new IOException("output stream is closed!");
        }
        if (this.isfirst) {
            this.sendHeader();
            this.isfirst = false;
        }
        this.bb.append(b);
        if (this.bb.size() >= this.buf_size) {
            this.flush();
        }
    }

    public void write(byte[] b) throws IOException {
        if (!this.isopen) {
            throw new IOException("output stream is closed!");
        }
        if (b == null) {
            throw new IOException("b is null!");
        }
        if (this.b_Direct) {
            this.out.write(b);
            return;
        }
        this.bb.append(b);
        if (this.bb.size() >= this.buf_size) {
            this.flush();
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (!this.isopen) {
            throw new IOException("output stream is closed!");
        }
        if (this.b_Direct) {
            this.out.write(b, off, len);
            return;
        }
        this.bb.append(b, off, len);
        if (this.bb.size() >= this.buf_size) {
            this.flush();
        }
    }

    public void flush() throws IOException {
        if (this.isfirst) {
            this.sendHeader();
            this.isfirst = false;
        }
        if (this.b_Direct) {
            this.out.flush();
            return;
        }
        if (this.bb.length() <= 0) {
            return;
        }
        byte[] bs = this.bb.getBuffer();
        this.out.write(this.bb.getBuffer());
        this.bb.clear();
        this.out.flush();
    }

    public boolean isCommitted() {
        return !this.isfirst;
    }

    public void clear() {
        this.bb.clear();
    }

    public void reset() {
        this.bb.clear();
    }

    public void close() throws IOException {
        if (this.isfirst) {
            this.sendHeader();
            this.isfirst = false;
        }
        if (this.bb.length() > 0) {
            this.out.write(this.bb.getBuffer());
        }
        this.bb.clear();
        this.out.close();
        this.isopen = false;
    }

    private void sendHeader() throws IOException {
        byte[] bs_version = ResponseHeader.http_version;
        byte[] bs_crlf = ResponseHeader.crlf;
        byte[] bs_sp = " ".getBytes();
        byte[] bs_colon = ":".getBytes();
        byte[] bs_code = this.rh.getCode().getBytes();
        byte[] bs_value = this.rh.getValue().getBytes();
        byte[] bs_server = ResponseHeader.server;
        byte[] bs_date = this.rh.getDate().getBytes();
        byte[] bs_length = String.valueOf(this.bb.length()).getBytes();
        this.out.write(bs_version);
        this.out.write(bs_sp);
        this.out.write(bs_code);
        this.out.write(bs_sp);
        this.out.write(bs_value);
        this.out.write(bs_crlf);
        if (this.shouldSendContentLength) {
            this.out.write("Content-Length".getBytes());
            this.out.write(bs_colon);
            this.out.write(bs_sp);
            this.out.write(bs_length);
            this.out.write(bs_crlf);
        }
        String str_name = "";
        String str_value = "";
        byte[] bs_name = null;
        Enumeration xenum = this.rh.hs_header.keys();
        while (xenum.hasMoreElements()) {
            str_name = (String)xenum.nextElement();
            if (str_name == null || (str_value = (String)this.rh.hs_header.get(str_name)) == null) continue;
            bs_name = str_name.getBytes();
            bs_value = str_value.getBytes();
            this.out.write(bs_name);
            this.out.write(bs_colon);
            this.out.write(bs_sp);
            this.out.write(bs_value);
            this.out.write(bs_crlf);
        }
        this.out.write(bs_crlf);
        this.out.flush();
    }
}

