/*
 * Decompiled with CFR 0.152.
 */
package turbomail.authcenter.http.io;

import java.io.IOException;
import java.io.InputStream;
import turbomail.authcenter.http.RequestHeader;
import turbomail.authcenter.util.ByteBuffer;

public class WInputStream
extends InputStream {
    private InputStream in = null;
    private RequestHeader rh = null;
    private int available = 0;
    private ByteBuffer body_buf = null;
    private int cur_pos = -1;
    private int mark_pos = -1;
    private boolean isopen = true;

    public WInputStream(InputStream in, RequestHeader rh) {
        this.in = in;
        this.rh = rh;
        this.available = rh.getContentLength();
        this.body_buf = new ByteBuffer(this.available);
        int count = 1;
        if (this.available > 0) {
            try {
                byte[] buf = new byte[1];
                int i = in.read(buf);
                if (i == 1) {
                    this.body_buf.append(buf);
                }
                while (count < this.available) {
                    i = in.read(buf);
                    if (i == 1) {
                        this.body_buf.append(buf);
                    }
                    ++count;
                }
                this.cur_pos = 0;
            }
            catch (Exception ioe) {
                this.available = 0;
                ioe.printStackTrace();
            }
        }
    }

    public int readLine(byte[] b, int off, int len) throws IOException {
        if (this.available == 0) {
            return 0;
        }
        if (!this.isopen) {
            throw new IOException("input stream is closed");
        }
        if (this.cur_pos > this.available - 1) {
            return -1;
        }
        byte[] temp_bs = new byte[1];
        int i = 0;
        int i_len = 0;
        boolean isReturn = false;
        int i_available = this.available;
        if (this.available == 0) {
            return -1;
        }
        while (i_len < i_available) {
            if (i_len >= len) {
                return i_len;
            }
            i = this.read(temp_bs);
            if (i == -1) {
                if (isReturn) {
                    return i_len;
                }
                return -1;
            }
            if (temp_bs[0] == 13) {
                isReturn = true;
            }
            if (temp_bs[0] == 10 && isReturn) {
                b[off + i_len] = temp_bs[0];
                return ++i_len;
            }
            b[off + i_len] = temp_bs[0];
            ++i_len;
        }
        return i_available;
    }

    public int read() throws IOException {
        if (this.available == 0) {
            return 0;
        }
        if (!this.isopen) {
            throw new IOException("input stream is closed");
        }
        if (this.cur_pos > this.available - 1) {
            return -1;
        }
        byte i = this.body_buf.byteAt(this.cur_pos);
        ++this.cur_pos;
        return i;
    }

    public void setAvailable(int i) {
        this.available = i;
    }

    public int read(byte[] b) throws IOException {
        if (this.available == -1) {
            return this.in.read(b);
        }
        if (this.available == 0) {
            return 0;
        }
        if (!this.isopen) {
            throw new IOException("input stream is closed");
        }
        if (this.cur_pos > this.available - 1) {
            return -1;
        }
        int len = b.length;
        int i = 0;
        while (i < len) {
            b[i] = this.body_buf.byteAt(this.cur_pos);
            ++this.cur_pos;
            if (this.cur_pos > this.available - 1) {
                return i + 1;
            }
            ++i;
        }
        return len;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.available == 0) {
            return 0;
        }
        if (!this.isopen) {
            throw new IOException("input stream is closed");
        }
        if (this.cur_pos > this.available - 1) {
            return -1;
        }
        int i = 0;
        while (i < len) {
            b[i + off] = this.body_buf.byteAt(this.cur_pos);
            ++this.cur_pos;
            if (this.cur_pos > this.available - 1) {
                return i + 1;
            }
            ++i;
        }
        return len;
    }

    public long skip(long n) throws IOException {
        if (this.available == 0) {
            return 0L;
        }
        if (!this.isopen) {
            throw new IOException("input stream is closed");
        }
        if (this.cur_pos > this.available - 1) {
            return -1L;
        }
        int temp_pos = this.cur_pos;
        if ((temp_pos += (int)n) > this.available - 1) {
            int org_pos = this.cur_pos;
            this.cur_pos = this.available - 1;
            return this.cur_pos - org_pos;
        }
        this.cur_pos = temp_pos;
        return n;
    }

    public int available() throws IOException {
        return this.available;
    }

    public void mark(int readlimit) {
        this.mark_pos = this.cur_pos;
    }

    public void reset() throws IOException {
        if (this.mark_pos < 0) {
            return;
        }
        if (this.mark_pos > this.available - 1) {
            return;
        }
        this.cur_pos = this.mark_pos;
    }

    public boolean markSupported() {
        return true;
    }

    public void close() throws IOException {
        if (!this.isopen) {
            return;
        }
        this.isopen = false;
        this.in.close();
    }
}

