/*
 * Decompiled with CFR 0.152.
 */
package turbomail.authcenter.http.command;

import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import turbomail.authcenter.http.Log;
import turbomail.authcenter.http.WRequest;
import turbomail.authcenter.http.WResponse;
import turbomail.authcenter.http.command.CheckUser;
import turbomail.authcenter.http.command.GetUser;
import turbomail.authcenter.util.SysConf;
import turbomail.authcenter.util.Util;

public class GetUser_ldap
extends GetUser {
    public static void process(WRequest request, WResponse response) {
        LDAPConnection ld;
        block10: {
            String loginusername = request.getParameter("loginusername");
            String loginpassword = request.getParameter("loginpassword");
            String domain = request.getParameter("domain");
            String username = request.getParameter("username");
            if (!CheckUser.checkLogin(loginusername, loginpassword)) {
                CheckUser.fail(response);
                return;
            }
            ld = null;
            LDAPEntry findEntry = null;
            try {
                ld = new LDAPConnection();
                String MY_HOST = SysConf.ldap_server;
                int MY_PORT = SysConf.ldap_port;
                ld.connect(MY_HOST, MY_PORT);
                String MY_FILTER = "";
                MY_FILTER = "(username=" + username + ")";
                String MY_SEARCHBASE = SysConf.ldap_base_dn;
                if (MY_SEARCHBASE == null) {
                    MY_SEARCHBASE = "";
                }
                String real_base = "";
                real_base = MY_SEARCHBASE.equals("") ? "domain=" + domain : "domain=" + domain + "," + MY_SEARCHBASE;
                LDAPSearchConstraints cons = ld.getSearchConstraints();
                cons.setBatchSize(2);
                cons.setMaxResults(10);
                LDAPSearchResults res = null;
                res = ld.search(real_base, 1, MY_FILTER, null, false, cons);
                String strTemp = "";
                StringBuffer bsContent = new StringBuffer();
                if (res.hasMoreElements()) {
                    try {
                        findEntry = res.next();
                    }
                    catch (Exception e) {
                        ld.disconnect();
                        e.printStackTrace();
                        return;
                    }
                    LDAPAttributeSet findAttrs = findEntry.getAttributeSet();
                    Object anAttr = null;
                    Object enumVals = null;
                    Object strValue = null;
                    String lTemp = Util.getLDAPValue(findAttrs, "modifytime");
                    bsContent.append("<?xml encoding=\"UTF-8\"?>\r\n");
                    bsContent.append("<user modifytime=\"");
                    bsContent.append(lTemp);
                    bsContent.append("\">\r\n");
                    bsContent.append("<general>\r\n");
                    bsContent.append("<username>");
                    bsContent.append(username);
                    bsContent.append("</username>\r\n");
                    strTemp = Util.getLDAPValue(findAttrs, "tpassword");
                    bsContent.append("<password>");
                    bsContent.append(strTemp);
                    bsContent.append("</password>\r\n");
                    strTemp = Util.getLDAPValue(findAttrs, "usertype");
                    bsContent.append("<usertype>");
                    bsContent.append(strTemp);
                    bsContent.append("</usertype>\r\n");
                    bsContent.append("</general>\r\n<services>\r\n");
                    strTemp = Util.getLDAPValue(findAttrs, "enable");
                    bsContent.append("<enable>");
                    bsContent.append(strTemp);
                    bsContent.append("</enable>\r\n");
                    strTemp = Util.getLDAPValue(findAttrs, "enablesmtp");
                    bsContent.append("<enable_smtp>");
                    bsContent.append(strTemp);
                    bsContent.append("</enable_smtp>\r\n");
                    strTemp = Util.getLDAPValue(findAttrs, "enablepop3");
                    bsContent.append("<enable_pop3>");
                    bsContent.append(strTemp);
                    bsContent.append("</enable_pop3>\r\n");
                    strTemp = Util.getLDAPValue(findAttrs, "enable_imap4");
                    bsContent.append("<enable_imap4>");
                    bsContent.append(strTemp);
                    bsContent.append("</enable_imap4>\r\n");
                    strTemp = Util.getLDAPValue(findAttrs, "enablewebaccess");
                    bsContent.append("<enable_webaccess>");
                    bsContent.append(strTemp);
                    bsContent.append("</enable_webaccess>\r\n");
                    strTemp = Util.getLDAPValue(findAttrs, "enable_localdomain");
                    bsContent.append("<enable_localdomain>");
                    bsContent.append(strTemp);
                    bsContent.append("</enable_localdomain>\r\n");
                    strTemp = Util.getLDAPValue(findAttrs, "enablesms");
                    bsContent.append("<enable_sms>");
                    bsContent.append(strTemp);
                    bsContent.append("</enable_sms>\r\n");
                    bsContent.append("</services>\r\n<mailbox>\r\n");
                    strTemp = Util.getLDAPValue(findAttrs, "maxmailboxsize");
                    bsContent.append("<max_mailbox_size>");
                    bsContent.append(strTemp);
                    bsContent.append("</max_mailbox_size>\r\n");
                    strTemp = Util.getLDAPValue(findAttrs, "maxmailboxmsgs");
                    bsContent.append("<max_mailbox_msgs>");
                    bsContent.append(strTemp);
                    bsContent.append("</max_mailbox_msgs>\r\n");
                    bsContent.append("</mailbox>\r\n</user>\r\n");
                    GetUser_ldap.success(response, bsContent.toString());
                    Log.log("get user " + username + "@" + domain);
                    break block10;
                }
                GetUser_ldap.fail(response);
            }
            catch (Exception ldape) {
                ldape.printStackTrace();
                GetUser_ldap.fail(response);
            }
        }
        if (ld != null && ld.isConnected()) {
            try {
                ld.disconnect();
            }
            catch (LDAPException e) {
                e.printStackTrace();
            }
        }
    }
}

