/*
 * Decompiled with CFR 0.152.
 */
package turbomail.authcenter.http.command;

import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import turbomail.authcenter.http.WRequest;
import turbomail.authcenter.http.WResponse;
import turbomail.authcenter.http.command.CheckUser;
import turbomail.authcenter.http.command.GetDomains;
import turbomail.authcenter.util.SysConf;
import turbomail.authcenter.util.Util;

public class GetDomains_ldap
extends GetDomains {
    public static void process(WRequest request, WResponse response) {
        String loginpassword;
        String loginusername = request.getParameter("loginusername");
        if (!CheckUser.checkLogin(loginusername, loginpassword = request.getParameter("loginpassword"))) {
            CheckUser.fail(response);
            return;
        }
        LDAPConnection ld = null;
        LDAPEntry findEntry = null;
        try {
            ld = new LDAPConnection();
            String MY_HOST = SysConf.ldap_server;
            int MY_PORT = SysConf.ldap_port;
            ld.connect(MY_HOST, MY_PORT);
            String MY_FILTER = "";
            MY_FILTER = "(domain=*)";
            String MY_SEARCHBASE = SysConf.ldap_base_dn;
            if (MY_SEARCHBASE == null) {
                MY_SEARCHBASE = "";
            }
            LDAPSearchConstraints cons = ld.getSearchConstraints();
            cons.setBatchSize(5);
            cons.setMaxResults(1000);
            LDAPSearchResults res = null;
            res = ld.search(MY_SEARCHBASE, 1, MY_FILTER, null, false, cons);
            String strTemp = "";
            StringBuffer bsContent = new StringBuffer();
            bsContent.append("<?xml encoding=\"UTF-8\"?>\r\n");
            bsContent.append("<DOMAINS>\r\n");
            while (res.hasMoreElements()) {
                try {
                    findEntry = res.next();
                }
                catch (Exception e) {
                    ld.disconnect();
                    e.printStackTrace();
                    return;
                }
                LDAPAttributeSet findAttrs = findEntry.getAttributeSet();
                Object anAttr = null;
                Object enumVals = null;
                Object strValue = null;
                strTemp = Util.getLDAPValue(findAttrs, "domain");
                if (strTemp.toLowerCase().equals("root")) continue;
                bsContent.append("<DOMAIN");
                bsContent.append(" NAME=\"" + strTemp + "\"");
                strTemp = Util.getLDAPValue(findAttrs, "helodomain");
                bsContent.append(" HELODOMAIN=\"" + strTemp + "\"");
                strTemp = Util.getLDAPValue(findAttrs, "bdefault");
                bsContent.append(" DEFAULT=\"" + strTemp + "\"");
                strTemp = Util.getLDAPValue(findAttrs, "state");
                bsContent.append(" STATE=\"" + strTemp + "\"");
                strTemp = Util.getLDAPValue(findAttrs, "domainusers");
                bsContent.append(" USERS=\"" + strTemp + "\">");
                bsContent.append("</DOMAIN>\r\n");
            }
            bsContent.append("</DOMAINS>");
            GetDomains_ldap.success(response, bsContent.toString());
        }
        catch (Exception ldape) {
            ldape.printStackTrace();
            GetDomains_ldap.fail(response);
        }
        if (ld != null && ld.isConnected()) {
            try {
                ld.disconnect();
            }
            catch (LDAPException e) {
                e.printStackTrace();
            }
        }
    }
}

