/*
 * Decompiled with CFR 0.152.
 */
package turbomail.authcenter.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Locale;
import turbomail.authcenter.http.LocalName;
import turbomail.authcenter.http.ResponseHeader;
import turbomail.authcenter.http.WRequest;
import turbomail.authcenter.http.io.WOutputStream;
import turbomail.authcenter.util.ServerInfo;
import turbomail.authcenter.util.Util;

public class WResponse {
    private WOutputStream os = null;
    private ResponseHeader rh = null;
    private static HashMap errors = new HashMap();
    public PrintWriter pw = null;
    private boolean canSetHeader = true;
    public WRequest request = null;

    static {
        errors = new HashMap();
        errors.put("100", "Continue");
        errors.put("101", "Switching Protocols");
        errors.put("200", "OK");
        errors.put("201", "Created");
        errors.put("202", "Accepted");
        errors.put("203", "Non-Authoritative Information");
        errors.put("204", "No Content");
        errors.put("205", "Reset Content");
        errors.put("206", "Partial Content");
        errors.put("300", "Multiple Choices");
        errors.put("301", "Moved Perminantly");
        errors.put("302", "Found");
        errors.put("303", "See Other");
        errors.put("304", "Not Modified");
        errors.put("305", "Use Proxy");
        errors.put("307", "Temporary Redirect");
        errors.put("400", "Bad Request");
        errors.put("401", "Unauthorized");
        errors.put("402", "Payment Required");
        errors.put("403", "Forbidden");
        errors.put("404", "File Not Found");
        errors.put("405", "Method Not Allowed");
        errors.put("406", "Not Acceptable");
        errors.put("407", "Proxy Authentication Required");
        errors.put("408", "Request Timeout");
        errors.put("409", "Conflict");
        errors.put("410", "Gone");
        errors.put("411", "Length Required");
        errors.put("412", "Precondition Failed");
        errors.put("413", "Request Entity Too Large");
        errors.put("414", "Request-URI Too Long");
        errors.put("415", "Unsupported Media Type");
        errors.put("416", "Requested Range Not Satisfiable");
        errors.put("417", "Expectation Failed");
        errors.put("500", "Internal Server Error");
        errors.put("501", "Not Implemented");
        errors.put("502", "Bad Gateway");
        errors.put("503", "Service Unavailable");
        errors.put("504", "Gateway Timeout");
        errors.put("505", "Http Version Not Supported");
    }

    public WResponse(WOutputStream out, ResponseHeader rh) {
        this.os = out;
        this.rh = rh;
    }

    public void SetDirect(boolean bD) {
        this.os.SetDirect(bD);
    }

    public ResponseHeader getResponseHeader() {
        return this.rh;
    }

    public void disableSetHeader() {
        this.canSetHeader = false;
    }

    public void enableSetHeader() {
        this.canSetHeader = true;
    }

    public void setHeader(String name, String value) {
        if (this.canSetHeader) {
            this.rh.setHeader(name, value);
        }
    }

    public String getCharacterEncoding() {
        String str_locale = this.rh.getHeader("Content-Language");
        if (str_locale == null) {
            return null;
        }
        String str_encode = LocalName.getCharacterEncoding(str_locale);
        return str_encode;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.os;
    }

    public WOutputStream getWOutputStream() throws IOException {
        return this.os;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.pw == null) {
            this.pw = new PrintWriter(this.os);
        }
        return this.pw;
    }

    public void setBufferSize(int size) {
        this.os.setBufferSize(size);
    }

    public int getBufferSize() {
        return this.os.getBufferSize();
    }

    public void setContentLength(int len) {
        this.rh.setHeader("Content-Length", String.valueOf(len));
    }

    public void setContentType(String type) {
        this.rh.setHeader("Content-Type", type);
    }

    public void flushBuffer() throws IOException {
        this.os.flush();
    }

    public boolean isCommitted() {
        return this.os.isCommitted();
    }

    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response already comitted");
        }
        this.os.reset();
        this.rh.hs_header.clear();
        this.rh.setCode("");
        this.rh.setValue("");
    }

    public void setLocale(Locale loc) {
    }

    public Locale getLocale() {
        return null;
    }

    public boolean containsHeader(String name) {
        return this.rh.hs_header.contains(name);
    }

    public String encodeURL(String url) {
        return this.encodeRedirectURL(url);
    }

    public String encodeRedirectURL(String url) {
        String temp_url = url;
        temp_url = WResponse.encode(temp_url);
        return temp_url;
    }

    public String encodeUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public void sendError(int sc, String msg) throws IOException {
        this.sendError(String.valueOf(sc), msg);
    }

    public void sendError(int sc) throws IOException {
        this.sendError(String.valueOf(sc), "");
    }

    public void setDateHeader(String name, long date) {
        this.rh.setDateHeader(name, date);
    }

    public void addDateHeader(String name, long date) {
        this.rh.addDateHeader(name, date);
    }

    public void addHeader(String name, String value) {
        this.rh.addHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.rh.setIntHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.rh.setIntHeader(name, value);
    }

    public void setStatus(int sc) {
        String str_code = String.valueOf(sc);
        if (!errors.containsKey(str_code)) {
            return;
        }
        String str_value = (String)errors.get(str_code);
        if (str_value == null) {
            str_value = "";
        }
        this.rh.setCode(str_code);
        this.rh.setValue(str_value);
    }

    public void setStatus(int sc, String sm) {
        String str_code = String.valueOf(sc);
        if (!errors.containsKey(str_code)) {
            return;
        }
        if (sm == null) {
            sm = "";
        }
        this.rh.setCode(str_code);
        this.rh.setValue(sm);
    }

    public void sendError(String code, String value) throws IOException {
        String str_value;
        if (this.os.isCommitted()) {
            throw new IllegalStateException("data has already committed");
        }
        String str_code = code;
        if (str_code == null) {
            str_code = "404";
        }
        if ((str_value = (String)errors.get(str_code)) == null) {
            str_value = "";
        }
        if (value == null) {
            value = "";
        }
        value = value.trim();
        if (code.equals("302")) {
            this.rh.setHeader("Location", value);
            this.rh.setHeader("Status", "302");
        }
        this.rh.setCode(str_code);
        this.rh.setValue(str_value);
        value = Util.formatErrMsg(value);
        String str_content = "<html><title>" + str_code + "</title><body>" + "\n<font size=\"+6\"><b>" + str_code + "</b></font>&nbsp; &nbsp;<font size=\"+3\">" + str_value + "</font><p>" + value + "\n<p><hr size=\"0\"></p>" + "\n<p>" + ServerInfo.ServerName + "/" + ServerInfo.Server_MajorVersion + "." + ServerInfo.Server_MinorVersion + ServerInfo.Server_state + "</p>" + "\n</body></html>";
        this.setHeader("Content-Type", "text/html");
        this.os.write(str_content.getBytes());
        this.os.close();
    }

    public static String encode(String url) {
        int len = url.length();
        String temp_str = "";
        String temp_url = "";
        String str_1 = "";
        byte[] bs = null;
        int i = 0;
        while (i < len) {
            temp_str = url.substring(i, i + 1);
            try {
                bs = temp_str.getBytes("gb2312");
            }
            catch (Exception e) {
                bs = new byte[1];
            }
            if (bs.length == 1) {
                temp_url = String.valueOf(temp_url) + temp_str;
            } else {
                str_1 = Integer.toHexString(bs[0]);
                str_1 = str_1.substring(str_1.length() - 2, str_1.length());
                temp_url = String.valueOf(temp_url) + "%" + str_1;
                str_1 = Integer.toHexString(bs[1]);
                str_1 = str_1.substring(str_1.length() - 2, str_1.length());
                temp_url = String.valueOf(temp_url) + "%" + str_1;
            }
            ++i;
        }
        return temp_url;
    }

    private static String encode(String id, String url) {
        if (id == null || url == null) {
            return url;
        }
        int question = url.indexOf(63);
        StringBuffer buf = new StringBuffer();
        if (question < 0) {
            buf.append(url);
        } else {
            buf.append(url.substring(0, question));
        }
        buf.append(';');
        buf.append("jsessionid");
        buf.append('=');
        buf.append(id);
        if (question >= 0) {
            buf.append(url.substring(question));
        }
        return buf.toString();
    }
}

