/*
 * Decompiled with CFR 0.152.
 */
package turbomail.authcenter.dbpool;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;

public class SQLUtil {
    private static String emptyStr = "";
    private static SimpleDateFormat mysqlFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat mysqlFormatHiRes = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String escapeString(String str) {
        return SQLUtil.escapeString(str, 999999);
    }

    public static String escapeString(String str, int length) {
        if (str == null) {
            return emptyStr;
        }
        if (str.length() > length) {
            str = str.substring(0, length);
        }
        StringTokenizer st = new StringTokenizer(str, "'");
        StringBuffer buffer = null;
        while (st.hasMoreTokens()) {
            if (buffer == null) {
                buffer = new StringBuffer(str.length() + 20);
            } else {
                buffer.append("''");
            }
            buffer.append(st.nextToken());
        }
        if (buffer == null) {
            return str;
        }
        return buffer.toString();
    }

    public static String notNull(String str) {
        if (str == null) {
            return emptyStr;
        }
        return str;
    }

    public static String formatMysqlDate(Date date) {
        if (date == null) {
            return "";
        }
        return mysqlFormat.format(date);
    }

    public static Date parseMysqlDate(String date_str) {
        if (date_str == null || date_str.equals("0000-00-00")) {
            return null;
        }
        try {
            return mysqlFormat.parse(date_str);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String formatHiResMysqlDate(Date date) {
        if (date == null) {
            return "";
        }
        return mysqlFormatHiRes.format(date);
    }

    public static String booleanToString(boolean b) {
        if (b) {
            return "y";
        }
        return "n";
    }

    public static boolean stringToBoolean(String str) {
        return str != null && str.equals("y");
    }
}

