/*
 * Decompiled with CFR 0.152.
 */
package turbomail.authcenter.dbpool;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import turbomail.authcenter.dbpool.ConnectionPool;
import turbomail.authcenter.dbpool.PooledPreparedStatement;
import turbomail.authcenter.dbpool.PooledStatement;

public class PooledConnection
implements Connection,
Runnable {
    private ConnectionPool pool;
    private Connection conn;
    private boolean locked;
    private long lastAccess;
    private long lastCheckin;
    private int checkoutCount;
    private PooledStatement theStatement = null;
    int totalStatements;
    int preparedCalls;
    int preparedStatementHits;
    int preparedStatementMisses;
    private Exception traceException;
    private static final int closedConnMaxRetry = 5;
    private static final int closedConnRetryWait = 1000;
    private Map prepStmts;
    private List callableStmts;

    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLException("not support this function");
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("not support this function");
    }

    public int getHoldability() throws SQLException {
        throw new SQLException("not support this function");
    }

    public void setHoldability(int holdability) throws SQLException {
        throw new SQLException("not support this function");
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLException("not support this function");
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("not support this function");
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("not support this function");
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("not support this function");
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("not support this function");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLException("not support this function");
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("not support this function");
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("not support this function");
    }

    public PooledConnection(Connection conn, ConnectionPool pool) {
        this.conn = conn;
        this.pool = pool;
        this.locked = false;
        this.lastAccess = 0L;
        this.checkoutCount = 0;
        this.totalStatements = 0;
        this.prepStmts = new HashMap();
        this.callableStmts = new LinkedList();
    }

    public void run() {
        try {
            this.closeStatements();
        }
        catch (SQLException e) {
            System.err.println("PooledConnection" + e);
        }
        try {
            this.getConnection().close();
        }
        catch (SQLException e) {
            System.err.println("PooledConnection" + e);
        }
    }

    public void closeStatements() throws SQLException {
        if (this.theStatement != null) {
            this.theStatement.getStatement().close();
        }
        Iterator<Object> it = this.prepStmts.values().iterator();
        while (it.hasNext()) {
            try {
                PooledPreparedStatement stmt = (PooledPreparedStatement)it.next();
                stmt.getStatement().close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        it = this.callableStmts.iterator();
        while (it.hasNext()) {
            try {
                ((CallableStatement)it.next()).close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    public synchronized boolean getLock() {
        if (this.locked) {
            return false;
        }
        this.locked = true;
        ++this.checkoutCount;
        this.lastAccess = System.currentTimeMillis();
        return true;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public int getCheckoutCount() {
        return this.checkoutCount;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public long getLastCheckin() {
        return this.lastCheckin;
    }

    public void close() throws SQLException {
        this.lastAccess = System.currentTimeMillis();
        this.pool.returnConnection(this);
    }

    protected void releaseLock() {
        this.lastCheckin = System.currentTimeMillis();
        this.locked = false;
    }

    protected Connection getConnection() {
        return this.conn;
    }

    public Connection getNativeConnection() {
        return this.conn;
    }

    public String dumpInfo() {
        String LS = System.getProperty("line.separator");
        String report = "\t\tConnection: " + this.toString() + LS;
        report = String.valueOf(report) + "\t\t\tStatements Requested: " + this.totalStatements + LS;
        report = String.valueOf(report) + "\t\t\tPrepared Calls: " + this.preparedCalls + LS;
        report = String.valueOf(report) + "\t\t\tPrepared Statements Hits: " + this.preparedStatementHits + LS;
        report = String.valueOf(report) + "\t\t\tPrepared Statements Misses: " + this.preparedStatementMisses + LS;
        report = String.valueOf(report) + "\t\t\tCheckout count: " + this.getCheckoutCount() + LS;
        report = String.valueOf(report) + "\t\t\tLast Checkout: " + this.getLastAccess() + ": " + new Date(this.getLastAccess()) + LS;
        report = String.valueOf(report) + "\t\t\tLast Checkin : " + this.getLastCheckin() + ": " + new Date(this.getLastCheckin()) + LS;
        report = String.valueOf(report) + "\t\t\t" + (this.isLocked() ? "Connection IS checked out." : "Connection is NOT checked out.") + LS;
        report = String.valueOf(report) + "\t\t\tCheckout Stack Trace: ";
        if (this.traceException != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.traceException.printStackTrace(pw);
            report = String.valueOf(report) + sw.toString();
        } else {
            report = String.valueOf(report) + "null";
        }
        report = String.valueOf(report) + LS;
        if (this.theStatement != null) {
            report = String.valueOf(report) + this.theStatement.dumpInfo();
        }
        return report;
    }

    public void guardConnection() {
        boolean badConnection;
        try {
            badConnection = this.conn.isClosed();
        }
        catch (SQLException sqe) {
            badConnection = true;
        }
        if (badConnection) {
            ++this.pool.numConnectionFaults;
            this.theStatement = null;
            int retryCount = 0;
            retryCount = 0;
            while (retryCount < 5) {
                block8: {
                    try {
                        this.conn = this.pool.createDriverConnection();
                    }
                    catch (SQLException SQE) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ie) {
                            System.err.println("PooledConnection: " + ie);
                        }
                        break block8;
                    }
                    return;
                }
                ++retryCount;
            }
        }
    }

    public Statement createStatement() throws SQLException {
        this.guardConnection();
        ++this.totalStatements;
        this.theStatement = new PooledStatement(this.conn.createStatement());
        return this.theStatement;
    }

    public Map getTypeMap() throws SQLException {
        return this.conn.getTypeMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement stmt = (PreparedStatement)this.prepStmts.get(sql);
        if (stmt == null) {
            stmt = this.conn.prepareStatement(sql);
            stmt = new PooledPreparedStatement(stmt);
            Map map = this.prepStmts;
            synchronized (map) {
                this.prepStmts.put(sql, stmt);
            }
            ++this.preparedStatementMisses;
        } else {
            ++this.preparedStatementHits;
        }
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        ++this.preparedStatementMisses;
        PreparedStatement stmt = this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
        return stmt;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        ++this.preparedCalls;
        CallableStatement stmt = this.conn.prepareCall(sql);
        this.callableStmts.add(stmt);
        return stmt;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        ++this.preparedCalls;
        CallableStatement stmt = this.conn.prepareCall(sql, resultSetType, resultSetConcurrency);
        this.callableStmts.add(stmt);
        return stmt;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        ++this.totalStatements;
        return this.conn.createStatement(resultSetType, resultSetConcurrency);
    }

    public String nativeSQL(String sql) throws SQLException {
        return this.conn.nativeSQL(sql);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.conn.setAutoCommit(autoCommit);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.conn.getAutoCommit();
    }

    public void commit() throws SQLException {
        this.conn.commit();
    }

    public void rollback() throws SQLException {
        this.conn.rollback();
    }

    public boolean isClosed() throws SQLException {
        return this.conn.isClosed();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.conn.getMetaData();
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.conn.setReadOnly(readOnly);
    }

    public boolean isReadOnly() throws SQLException {
        return this.conn.isReadOnly();
    }

    public void setCatalog(String catalog) throws SQLException {
        this.conn.setCatalog(catalog);
    }

    public String getCatalog() throws SQLException {
        return this.conn.getCatalog();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.conn.setTypeMap(map);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.conn.setTransactionIsolation(level);
    }

    public int getTransactionIsolation() throws SQLException {
        return this.conn.getTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.conn.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.conn.clearWarnings();
    }

    protected void setTraceException(Exception e) {
        this.traceException = e;
    }

    public Exception getTraceException() {
        return this.traceException;
    }
}

