/*
 * Decompiled with CFR 0.152.
 */
package turbomail.authcenter.dbpool;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import turbomail.authcenter.dbpool.ConnectionPool;

public class ConnectionPoolManager
implements Driver,
Runnable {
    public static final String URL_PREFIX = "jdbc:turbomail:dbpool:";
    private static final int MAJOR_VERSION = 0;
    private static final int MINOR_VERSION = 92;
    private Hashtable aliasHash = new Hashtable();
    private long sleepInterval;
    private boolean trace = false;

    public ConnectionPoolManager() throws SQLException {
        DriverManager.registerDriver(this);
    }

    public ConnectionPoolManager(int monitorInterval) throws SQLException {
        this();
        this.sleepInterval = monitorInterval * 1000;
        Thread t = new Thread(this);
        t.setDaemon(true);
        t.start();
    }

    public void addAlias(String alias, String driver, String url, String username, String password, int maxConn, int idleTimeout, int checkoutTimeout) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.addAlias(alias, driver, url, username, password, maxConn, idleTimeout, checkoutTimeout, 0);
    }

    public void addAlias(String alias, String driver, String url, Properties prop, int maxConn, int idleTimeout, int checkoutTimeout, int maxCheckout) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class.forName(driver).newInstance();
        ConnectionPool pool = new ConnectionPool(alias, url, prop, maxConn, idleTimeout, checkoutTimeout, maxCheckout);
        this.addAlias(pool);
    }

    public void addAlias(String alias, String driver, String url, String username, String password) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.addAlias(alias, driver, url, username, password, 10, 300, 120, 30);
    }

    public void addAlias(String alias, String driver, String url, String username, String password, int maxConn, int idleTimeout, int checkoutTimeout, int maxCheckout) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class.forName(driver).newInstance();
        ConnectionPool pool = new ConnectionPool(alias, url, username, password, maxConn, idleTimeout, checkoutTimeout, maxCheckout);
        this.addAlias(pool);
    }

    public void addAlias(String alias, String driver, String url, String username, String password, int maxConn, int idleTimeout, int checkoutTimeout, int maxCheckout, int rowPrefetch) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class.forName(driver).newInstance();
        ConnectionPool pool = new ConnectionPool(alias, url, username, password, maxConn, idleTimeout, checkoutTimeout, maxCheckout);
        pool.setPrefetchSize(rowPrefetch);
        this.addAlias(pool);
    }

    public synchronized void addAlias(ConnectionPool pool) {
        this.aliasHash.put(pool.getAlias(), pool);
    }

    public synchronized void removeAlias(String alias) throws SQLException {
        ConnectionPool p = this.getPool(alias);
        this.aliasHash.remove(alias);
        p.removeAllConnections();
    }

    public Enumeration getPools() {
        return this.aliasHash.elements();
    }

    public ConnectionPool getPool(String alias) throws SQLException {
        ConnectionPool p = (ConnectionPool)this.aliasHash.get(alias);
        if (p == null) {
            throw new SQLException("No connection pool created for alias: " + alias);
        }
        return p;
    }

    public void run() {
        block4: while (true) {
            try {
                Thread.currentThread();
                Thread.sleep(this.sleepInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Enumeration e = this.aliasHash.elements();
            while (true) {
                if (!e.hasMoreElements()) continue block4;
                ConnectionPool pool = (ConnectionPool)e.nextElement();
                try {
                    pool.reapIdleConnections();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            break;
        }
    }

    public void setTracing(boolean on) {
        if (on != this.trace) {
            Enumeration e = this.getPools();
            while (e.hasMoreElements()) {
                ConnectionPool p = (ConnectionPool)e.nextElement();
                p.setTracing(on);
            }
            String str = "off";
            if (on) {
                str = "on";
            }
            this.trace = on;
        }
    }

    public Connection connect(String url, Properties props) throws SQLException {
        if (!url.startsWith(URL_PREFIX)) {
            return null;
        }
        if (url.length() <= URL_PREFIX.length()) {
            throw new SQLException("Invalid URL: " + url + " -- No alias given");
        }
        String alias = url.substring(URL_PREFIX.length());
        if (this.trace) {
            System.err.println("ConnectionPoolManager: connect() called for " + alias + ".  calling pool.getConnection()");
        }
        ConnectionPool p = this.getPool(alias);
        return p.getConnection();
    }

    public boolean acceptsURL(String url) {
        return url.startsWith(URL_PREFIX);
    }

    public int getMajorVersion() {
        return 0;
    }

    public int getMinorVersion() {
        return 92;
    }

    public DriverPropertyInfo[] getPropertyInfo(String str, Properties props) {
        return new DriverPropertyInfo[0];
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public String dumpInfo() {
        String LS = System.getProperty("line.separator");
        Enumeration allPools = this.getPools();
        String report = "";
        while (allPools.hasMoreElements()) {
            ConnectionPool currentPool = (ConnectionPool)allPools.nextElement();
            report = String.valueOf(report) + currentPool.dumpInfo();
        }
        return report;
    }
}

