/*
 * Decompiled with CFR 0.152.
 */
package turbomail.authcenter.dbpool;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import turbomail.authcenter.dbpool.PooledConnection;
import turbomail.authcenter.dbpool.Queue;
import turbomail.authcenter.dbpool.util.JavaAlarm;
import turbomail.authcenter.dbpool.util.TimeoutException;

public class ConnectionPool {
    Vector connVector;
    String url;
    private Queue waitingThreads;
    private String username;
    private String password;
    private String alias;
    private int maxConn;
    private int timeoutSeconds;
    private int checkoutSeconds;
    private int numCheckoutTimeout;
    private int numRequests;
    private int numWaits;
    private int maxCheckout;
    int numConnectionFaults = 0;
    private boolean trace = false;
    private int prefetchSize = -1;
    private Properties db_prop = null;

    public ConnectionPool(String alias, String url, String username, String password, int maxConn, int timeoutSeconds, int checkoutSeconds) {
        this(alias, url, username, password, maxConn, timeoutSeconds, checkoutSeconds, 0);
    }

    public ConnectionPool(String alias, String url, String username, String password, int maxConn, int timeoutSeconds, int checkoutSeconds, int maxCheckout) {
        this.timeoutSeconds = timeoutSeconds;
        this.checkoutSeconds = checkoutSeconds;
        this.alias = alias;
        this.url = url;
        this.username = username;
        this.password = password;
        this.maxConn = maxConn;
        this.maxCheckout = maxCheckout;
        this.numRequests = 0;
        this.numWaits = 0;
        this.numCheckoutTimeout = 0;
        this.connVector = new Vector(maxConn);
        this.waitingThreads = new Queue();
    }

    public ConnectionPool(String alias, String url, Properties prop, int maxConn, int timeoutSeconds, int checkoutSeconds, int maxCheckout) {
        this.timeoutSeconds = timeoutSeconds;
        this.checkoutSeconds = checkoutSeconds;
        this.alias = alias;
        this.url = url;
        this.db_prop = prop;
        this.maxConn = maxConn;
        this.maxCheckout = maxCheckout;
        this.numRequests = 0;
        this.numWaits = 0;
        this.numCheckoutTimeout = 0;
        this.connVector = new Vector(maxConn);
        this.waitingThreads = new Queue();
    }

    public void setTracing(boolean on) {
        this.trace = on;
    }

    public String getAlias() {
        return this.alias;
    }

    public int getNumRequests() {
        return this.numRequests;
    }

    public int getNumWaits() {
        return this.numWaits;
    }

    public int getNumCheckoutTimeouts() {
        return this.numCheckoutTimeout;
    }

    public int getMaxConn() {
        return this.maxConn;
    }

    public int size() {
        return this.connVector.size();
    }

    public synchronized void reapIdleConnections() {
        if (this.trace) {
            System.err.println("ConnectionPool: " + this.alias + " reapIdleConnections() starting, size=" + this.size());
        }
        long now = System.currentTimeMillis();
        long idleTimeout = now - (long)(this.timeoutSeconds * 1000);
        long checkoutTimeout = now - (long)(this.checkoutSeconds * 1000);
        int i = 0;
        while (i < this.connVector.size()) {
            PooledConnection conn = (PooledConnection)this.connVector.elementAt(i);
            if (conn.isLocked() && conn.getLastAccess() < checkoutTimeout) {
                ++this.numCheckoutTimeout;
                this.removeConnection(conn);
                this.notifyAll();
            } else if (conn.getLastAccess() < idleTimeout && conn.getLock()) {
                this.removeConnection(conn);
                conn.releaseLock();
                this.notifyAll();
            }
            ++i;
        }
        if (this.trace) {
            System.err.println("ConnectionPool: " + this.alias + " reapIdleConnections() finished");
        }
    }

    public synchronized void removeAllConnections() {
        if (this.trace) {
            System.err.println("ConnectionPool: " + this.alias + " removeAllConnections() called");
        }
        while (!this.connVector.isEmpty()) {
            PooledConnection conn = (PooledConnection)this.connVector.firstElement();
            this.removeConnection(conn);
        }
    }

    private synchronized void removeConnection(PooledConnection conn) {
        try {
            JavaAlarm alarm = new JavaAlarm((Runnable)conn, 10000L);
            this.connVector.removeElement(conn);
        }
        catch (TimeoutException e) {
            if (this.trace) {
                e.printStackTrace();
            }
            System.err.println("ConnectionPool" + e);
        }
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.trace) {
            System.err.println("ConnectionPool: " + this.alias + " getConnection() called");
        }
        ++this.numRequests;
        while (true) {
            PooledConnection p;
            int i = 0;
            while (i < this.connVector.size()) {
                p = (PooledConnection)this.connVector.elementAt(i);
                if (p.getLock()) {
                    return this.releaseConnection(p);
                }
                ++i;
            }
            if (this.trace) {
                System.err.println("ConnectionPool: " + this.alias + " all connections locked.  calling" + " createConnection()");
            }
            if (this.connVector.size() < this.maxConn) {
                if (this.trace) {
                    System.err.println("ConnectionPool: " + this.alias + " opening new connection to database size=" + this.size());
                }
                Connection conn = this.createDriverConnection();
                if (this.trace) {
                    System.err.println("ConnectionPool: " + this.alias + " finished opening new connection");
                }
                p = new PooledConnection(conn, this);
                p.getLock();
                this.connVector.addElement(p);
                return this.releaseConnection(p);
            }
            try {
                if (this.trace) {
                    System.err.println("ConnectionPool: " + this.alias + " pool is full.  calling wait()");
                }
                ++this.numWaits;
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.trace) continue;
            System.err.println("ConnectionPool: " + this.alias + " awoken from wait().  trying to grab" + " an available connection");
        }
    }

    private synchronized Connection releaseConnection(PooledConnection connection) {
        if (this.trace) {
            try {
                throw new RuntimeException();
            }
            catch (RuntimeException e) {
                connection.setTraceException(e);
            }
        }
        return connection;
    }

    Connection createDriverConnection() throws SQLException {
        if (this.db_prop != null) {
            return DriverManager.getConnection(this.url, this.db_prop);
        }
        return DriverManager.getConnection(this.url, this.username, this.password);
    }

    public synchronized void returnConnection(PooledConnection conn) {
        if (this.maxCheckout > 0 && conn.getCheckoutCount() >= this.maxCheckout) {
            if (this.trace) {
                System.err.println("ConnectionPool: " + this.alias + " connection checked out max # of times." + " closing it.");
            }
            this.removeConnection(conn);
        }
        if (this.trace) {
            System.err.println("ConnectionPool: " + this.alias + " releasing lock and calling notifyAll()");
        }
        conn.releaseLock();
        this.notifyAll();
    }

    public String dumpInfo() {
        String LS = System.getProperty("line.separator");
        String report = "Pool: " + this.toString() + LS;
        report = String.valueOf(report) + "\tAlias: " + this.getAlias() + LS;
        report = String.valueOf(report) + "\tMax connections: " + this.getMaxConn() + LS;
        report = String.valueOf(report) + "\tURL: " + this.url + LS;
        report = String.valueOf(report) + "\tCheckouts: " + this.getNumRequests() + LS;
        report = String.valueOf(report) + "\tThread waits: " + this.getNumWaits() + LS;
        report = String.valueOf(report) + "\tConnections found closed: " + this.numConnectionFaults + LS;
        report = String.valueOf(report) + "\tConnections reaped by timeout: " + this.getNumCheckoutTimeouts() + LS;
        report = String.valueOf(report) + "\tConnections currently in pool: " + this.size() + LS;
        Vector connectionVector = this.connVector;
        int i = 0;
        while (i < connectionVector.size()) {
            PooledConnection pc = (PooledConnection)connectionVector.elementAt(i);
            if (pc != null) {
                report = String.valueOf(report) + pc.dumpInfo();
            }
            ++i;
        }
        return report;
    }

    public void setPrefetchSize(int newPrefetchSize) {
        this.prefetchSize = newPrefetchSize;
    }

    public int getPrefetchSize() {
        return this.prefetchSize;
    }
}

